from plan.services.models import Service


def process_form_forward(data, form_metadata, cleaned_data):
    attributes_names = (
        'data', 'subject', 'service_from_slug',
        'purpose', 'store_for', 'store_in', 'is_storing',
        'is_using', 'path_to_data', 'access_from_yql_sql',
        'access_from_api', 'access_from_web_cloud',
        'access_from_file_based',
    )

    attrs = {}

    for field in data.values():
        constuctor_slug = field['question']['slug']
        if constuctor_slug in attributes_names:
            attrs[constuctor_slug] = field['value']

    service_slug = Service.objects.get(name=attrs['service_from_slug']).slug
    attrs['service_from_slug'] = service_slug

    resource_name = 'Пользовательские данные "{}" от {}'.format(
        attrs['data'], attrs['service_from_slug']
    )

    result = {
        'name': resource_name,
        'attributes': attrs,
    }
    return result
