from django.conf import settings

from plan.api.exceptions import BadRequest
from plan.resources.models import Resource, ServiceResource


def process_form_forward(data, form_metadata, cleaned_data):
    attrs = {}
    attributes_names = ('resource_name', 'tvm_client_id', 'change_name')

    for field in data.values():
        constuctor_slug = field['question']['slug']
        if constuctor_slug in attributes_names:
            attrs[constuctor_slug] = field['value']

    result = {}

    tvm_client_id = attrs.get('tvm_client_id')
    if tvm_client_id:
        result['external_id'] = tvm_client_id
        if cleaned_data.get('service_resource'):
            raise BadRequest(message={
                'ru': 'Нельзя изменить tvmid у существующего ресурса',
                'en': 'You cant change the tvmid of an existing resource',
            })
        existing_resource = Resource.objects.filter(
            type__code=settings.TVM_RESOURCE_TYPE_CODE,
            external_id=tvm_client_id
        ).exists()
        if not existing_resource:
            raise BadRequest(message={
                'ru': 'Передан неизвестный ABC tvmid',
                'en': 'Unknown by ABC tvmid was send',
            })

    name = attrs.get('resource_name') or attrs.get('change_name')
    if name:
        result['name'] = name
        service_resource = cleaned_data.get('service_resource')
        if service_resource and service_resource.state != ServiceResource.GRANTED:
            raise BadRequest(message={
                'ru': 'Нельзя изменить имя у не утвержденного ресурса',
                'en': 'You cant change the name of an unapproved resource',
            })

    if name and tvm_client_id:
        raise BadRequest(message={
            'ru': 'Нельзя сразу переместить tvm ресурс и переименовать его',
            'en': 'You cant immediately move the tvm resource and rename it',
        })

    return result
