DEFAULT_SCENARIO = 'Другое'


def process_form_backward(attributes, form_metadata):
    location_items = form_metadata['fields']['location']['data_source']['items']
    segment_items = form_metadata['fields']['segment']['data_source']['items']
    gpu_model_items = form_metadata['fields']['gpu_model']['data_source']['items']
    scenario_items = form_metadata['fields']['scenario']['data_source']['items']
    scenario_restricted_items = form_metadata['fields']['scenario_restricted']['data_source']['items']

    scenario_id = ''
    scenario = DEFAULT_SCENARIO
    scenario_attr = 'scenario'
    service_resource = attributes.get('service_resource')
    if service_resource:
        if service_resource.state == service_resource.REQUESTED:
            scenario = attributes.get('scenario', DEFAULT_SCENARIO)
        elif service_resource.state == service_resource.GRANTED:
            scenario_items = scenario_restricted_items
            scenario_attr = 'scenario_restricted'

    for item in scenario_items:
        if item['text'] == scenario:
            scenario_id = item['id']
            break

    location = attributes.get('location')
    for item in location_items:
        if item['text'] == location:
            location = item['id']
            break

    segment = attributes.get('segment')
    for item in segment_items:
        if item['text'] == segment:
            segment = item['id']
            break

    gpu_model = attributes.get('gpu_model')
    if gpu_model is not None:
        for item in gpu_model_items:
            if item['text'] == gpu_model:
                gpu_model = item['id']
                break

    result = {
        'location': location,
        'segment': segment,
        'cpu-float': attributes.get('cpu'),
        'memory': attributes.get('memory'),
        'hdd': attributes.get('hdd'),
        'ssd': attributes.get('ssd'),
        'ipv4': attributes.get('ip4', '') or attributes.get('ipv4', ''),
        'gencfg-groups': attributes.get('gencfg-groups', ''),
        'description': attributes.get('description', ''),
        'io_ssd': attributes.get('io_ssd', ''),
        'io_hdd': attributes.get('io_hdd', ''),
        'net': attributes.get('net', ''),
        'gpu_model': gpu_model,
        'gpu_qty': attributes.get('gpu_qty', ''),
    }

    if scenario_attr == 'scenario_restricted':
        result['is_scenario_restricted'] = True

    result[scenario_attr] = scenario_id

    if 'donor_slug' in attributes:
        result['service_donor'] = attributes['donor_slug']

    return result
