from plan.api.exceptions import BadRequest

EMPTY_VALUES = (None, 0, '', '0')


def process_form_forward(data, form_metadata):
    from collections import OrderedDict

    # слаг филда из КФ -> (
    # название атрибута,
    # часть имени ресурса, если атрибут участвует в его формировании,
    # если True, включать атрибут в формирование имени ресурса,
    # если True, не сохранять атрибут при пустом значении,
    # )

    mapping = OrderedDict([
        ('scenario_restricted', ('scenario', None, False, False)),
        ('scenario', ('scenario', None, False, False)),
        ('location', ('location', 'loc', False, False)),
        ('segment', ('segment', 'seg', False, False)),
        ('cpu-float', ('cpu', 'cpu', True, False)),
        ('memory', ('memory', 'mem', True, False)),
        ('hdd', ('hdd', 'hdd', True, False)),
        ('ssd', ('ssd', 'ssd', True, False)),
        ('ipv4', ('ip4', 'ip4', True, False)),
        ('net', ('net', 'net', True, False)),
        ('io_ssd', ('io_ssd', 'io_ssd', True, False)),
        ('io_hdd', ('io_hdd', 'io_hdd', True, False)),
        ('gpu_model', ('gpu_model', 'gpu', True, True)),
        ('gpu_qty', ('gpu_qty', 'gpu_q', True, True)),
        ('gencfg-groups', ('gencfg-groups', None, False, False)),
        ('description', ('description', None, False, False)),
        ('service_donor', ('donor_slug', None, False, False)),
    ])

    attrs = {}
    name = []

    need_to_create = False

    for field in data.values():
        constuctor_slug = field['question']['slug']
        if constuctor_slug in mapping:
            attr_name, _, is_resource, non_zero = mapping[constuctor_slug]
            if attr_name in attrs and attrs[attr_name] not in EMPTY_VALUES:
                continue
            empty_value = field['value'] in EMPTY_VALUES
            if non_zero and empty_value:
                continue
            need_to_create |= is_resource and not empty_value
            if constuctor_slug == 'service_donor':
                if field['value']:
                    attrs[attr_name] = field['value']
            else:
                attrs[attr_name] = field['value'] or '0'

    if not need_to_create:
        raise BadRequest(message={
            'ru': 'Запрещен запрос пустых квот',
            'en': 'Empty quota request is forbidden',
        })

    for _, pair in mapping.items():
        attr_name, name_bit, _, _ = pair
        if name_bit is not None and attr_name in attrs:
            value = attrs[attr_name]
            name.append(f'{name_bit}:{value}')

    result = {
        'name': '-'.join(name),
        'attributes': attrs,
    }
    return result
