import attr
import logging
from importlib import import_module

from plan.common.utils.http import Session

logger = logging.getLogger(__name__)

# TODO: сделать autodiscover?
PLUGINS = {
    'crt': 'CrtPlugin',
    'generic': 'GenericPlugin',
    'wiki': 'WikiPlugin',
    'warden': 'WardenPlugin',
    'arcadia': 'ArcadiaPlugin',
}
UNSYNCED = {'crt'}


class Plugin(object):
    resource_type = None
    _cache = None
    oauth_token = None

    @classmethod
    def get_plugin_class(cls, plugin):
        plugin_class = PLUGINS[plugin]

        mod = import_module('plan.resources.importers.%s' % plugin)
        return getattr(mod, plugin_class)

    @classmethod
    def get_synced(cls):
        return [key for key in PLUGINS.keys() if key not in UNSYNCED]

    def __init__(self, resource_type, *args, **kwargs):
        self.resource_type = resource_type
        self.session = Session(oauth_token=self.oauth_token)

    def get_resources(self, service):
        raise NotImplementedError

    def fetch(self):
        raise NotImplementedError

    def sync_state(self):
        """
        действия, которые необходимо выполнить после синхронизации
        ресурсов с поставщиком
        """
        pass


@attr.s(frozen=True)
class BaseObject(object):
    base_url = attr.ib()
    name = attr.ib()
    services = attr.ib()

    @property
    def link(self):
        return None

    @property
    def resource_params(self):
        return {
            'external_id': self.id,
            'name': self.name,
            'link': self.link,
        }

    @property
    def not_required_params(self):
        return None

    @classmethod
    def from_api_data(cls, obj, base_url):
        raise NotImplementedError()
