import logging
from django.core.management.base import BaseCommand
from django.db import connection

from plan.resources.models import ServiceResource

log = logging.getLogger(__name__)

UPDATE_QUERY = '''
UPDATE resources_serviceresource
SET type_id = res.type_id
FROM resources_resource AS res
WHERE resources_serviceresource.resource_id = res.id
AND resources_serviceresource.id IN (
    SELECT "resources_serviceresource"."id"
    FROM "resources_serviceresource"
    WHERE "resources_serviceresource"."type_id" IS NULL
    LIMIT 1000
)
'''


class Command(BaseCommand):
    def handle(self, *args, **options):
        log.info('Start fill type in serviserosources')
        total_count = ServiceResource.objects.filter(type=None).count()
        updated_count = 0
        with connection.cursor() as cursor:
            while True:
                cursor.execute(UPDATE_QUERY)
                if not cursor.rowcount:
                    break
                updated_count += cursor.rowcount
                log.info('Updated %s serviserosources from %s', updated_count, total_count)
            log.info('Fill type in serviserosources finished, updated %s from %s', updated_count, total_count)
