import logging
from django.core.management.base import BaseCommand
from collections import OrderedDict

from plan.resources.models import Resource

log = logging.getLogger(__name__)


class Command(BaseCommand):
    def handle(self, *args, **options):
        name_bits = OrderedDict([
            ('loc', 'location'),
            ('seg', 'segment'),
            ('cpu', 'cpu'),
            ('mem', 'memory'),
            ('hdd', 'hdd'),
            ('ssd', 'ssd'),
            ('ip4', 'ip4'),
            ('io_ssd', 'io_ssd'),
            ('io_hdd', 'io_hdd'),
            ('gpu', 'gpu_model'),
            ('gpu_q', 'gpu_qty'),
        ])

        query = Resource.objects.filter(type__code='yt-quota', attributes__io_ssd__isnull=False).order_by('id')

        for resource in query:
            try:
                name = []
                for code, field_name in name_bits.items():
                    if field_name in resource.attributes:
                        name.append(f'{code}:{resource.attributes[field_name]}')

                old_name = resource.name
                resource.name = '-'.join(name)
                resource.save(update_fields=['name', ])
                log.info(f'Updated name for resource {resource} from {old_name} to {resource.name}.')

            except Exception:
                log.exception(f'Cannot modified resource {resource}.')
