import logging
from django.core.management.base import BaseCommand

from plan.resources.tasks import sync_resources

log = logging.getLogger(__name__)


class Command(BaseCommand):
    def handle(self, *args, **options):
        try:
            if args:
                sync_resources(args[0])
            else:
                sync_resources()
        except Exception as e:
            log.exception('Cannot import resources: %s', e)
