import logging
from django.core.management.base import BaseCommand

from django.utils.dateparse import parse_datetime
from plan.resources.models import ServiceResource

log = logging.getLogger(__name__)


class Command(BaseCommand):
    def handle(self, *args, **options):
        try:
            code = 'cert'
            query = ServiceResource.objects.filter(type__code=code)

            for service_resource in query:
                issued = parse_datetime(service_resource.resource.attributes['issued'])

                if service_resource.modified_at.date() != issued.date():
                    ServiceResource.objects.filter(pk=service_resource.pk).update(modified_at=issued)

        except Exception:
            log.exception('Cannot modified resources.')
