# flake8: noqa
from django.db import migrations, models

import plan.common.utils.fields


class Migration(migrations.Migration):

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Resource',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(help_text='\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0440\u0435\u0441\u0443\u0440\u0441\u0430 \u0432 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0435', max_length=128, verbose_name='\u0418\u043c\u044f')),
                ('attributes', plan.common.utils.fields.JSONField(help_text='\u0410\u0442\u0442\u0440\u0438\u0431\u0443\u0442\u044b \u0440\u0435\u0441\u0443\u0440\u0441\u0430 \u0438\u0437 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430', null=True, verbose_name='\u0410\u0442\u0442\u0440\u0438\u0431\u0443\u0442\u044b', blank=True)),
                ('link', models.URLField(help_text='\u0421\u0441\u044b\u043b\u043a\u0430 \u0440\u0435\u0441\u0443\u0440\u0441\u0430 \u0432 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0435', null=True, blank=True)),
                ('external_id', models.CharField(help_text='\u0412\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0438\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0440\u0435\u0441\u0443\u0440\u0441\u0430 \u0432 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0435', max_length=64, verbose_name='\u0412\u043d\u0435\u0448\u043d\u0438\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440')),
            ],
            options={
                'verbose_name': '\u0420\u0435\u0441\u0443\u0440\u0441',
                'verbose_name_plural': '\u0420\u0435\u0441\u0443\u0440\u0441\u044b',
            },
        ),
        migrations.CreateModel(
            name='ResourceType',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(help_text='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0442\u0438\u043f\u0430, \u043f\u0440\u0438\u043d\u044f\u0442\u043e\u0435 \u0432 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0435', max_length=128, verbose_name='\u0418\u043c\u044f')),
                ('import_link', models.URLField(default=None, null=True, help_text='\u0421\u0441\u044b\u043b\u043a\u0430 \u043d\u0430 \u0441\u043f\u0438\u0441\u043e\u043a \u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432', blank=True)),
                ('import_plugin', models.CharField(default='dummy', max_length=100, verbose_name='\u041f\u043b\u0430\u0433\u0438\u043d', choices=[('dummy', 'Dummy'), ('generic', 'Generic'), ('wiki', 'Wiki'), ('bot', 'BOT'), ('racktables', 'Racktables'), ('conductor', 'Conductor')])),
                ('import_handler', models.TextField(default=None, help_text='\u041a\u043e\u0434 \u043d\u0430 python, \u043e\u0431\u0440\u0430\u0431\u0430\u0442\u044b\u0432\u0430\u044e\u0449\u0438\u0439 \u0432\u0445\u043e\u0434\u044f\u0449\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u0438\u0437 api \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430', null=True, verbose_name='\u0418\u043c\u043f\u043e\u0440\u0442', blank=True)),
                ('form_link', models.URLField(default=None, blank=True, help_text='\u0421\u0441\u044b\u043b\u043a\u0430 \u043d\u0430 \u0444\u043e\u0440\u043c\u0443 \u0437\u0430\u043a\u0430\u0437\u0430 \u0440\u0435\u0441\u0443\u0440\u0441\u0430', null=True, verbose_name='\u041a\u043e\u043d\u0441\u0442\u0440\u0443\u043a\u0442\u043e\u0440')),
                ('form_type', models.CharField(default='constructor', max_length=100, verbose_name='\u0422\u0438\u043f \u0444\u043e\u0440\u043c\u044b', choices=[('constructor', '\u041a\u043e\u043d\u0441\u0442\u0440\u0443\u043a\u0442\u043e\u0440 \u0444\u043e\u0440\u043c')])),
                ('form_handler', models.TextField(default=None, help_text='\u041a\u043e\u0434 \u043d\u0430 python, \u043e\u0431\u0440\u0430\u0431\u0430\u0442\u044b\u0432\u0430\u044e\u0449\u0438\u0439 \u0432\u0445\u043e\u0434\u044f\u0449\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u0438\u0437 \u0444\u043e\u0440\u043c\u044b', null=True, verbose_name='\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430', blank=True)),
            ],
            options={
                'verbose_name': '\u0422\u0438\u043f \u0440\u0435\u0441\u0443\u0440\u0441\u0430',
                'verbose_name_plural': '\u0422\u0438\u043f\u044b \u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432',
            },
        ),
        migrations.CreateModel(
            name='ServiceResource',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('state', models.CharField(default='requested', max_length=50, verbose_name='\u0421\u0442\u0430\u0442\u0443\u0441', choices=[('requested', '\u0417\u0430\u043f\u0440\u043e\u0448\u0435\u043d'), ('rejected', '\u041e\u0442\u043a\u043b\u043e\u043d\u0435\u043d'), ('approved', '\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d'), ('granted', '\u0412\u044b\u0434\u0430\u043d'), ('deprived', '\u041e\u0442\u043e\u0437\u0432\u0430\u043d')])),
                ('request_id', models.PositiveIntegerField(default=None, help_text='\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043e\u0442\u0432\u0435\u0442\u0430 \u0432 \u043a\u043e\u043d\u0441\u0442\u0440\u0443\u043a\u0442\u043e\u0440\u0435 \u0444\u043e\u0440\u043c', null=True, verbose_name='\u041a\u043e\u0434 \u0437\u0430\u043a\u0430\u0437\u0430', blank=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('modified_at', models.DateTimeField(auto_now=True)),
                ('resource', models.ForeignKey(verbose_name='\u0420\u0435\u0441\u0443\u0440\u0441', to='resources.Resource')),
            ],
            options={
                'verbose_name': '\u0420\u0435\u0441\u0443\u0440\u0441 \u0441\u0435\u0440\u0432\u0438\u0441\u0430',
                'verbose_name_plural': '\u0420\u0435\u0441\u0443\u0440\u0441\u044b \u0441\u0435\u0440\u0432\u0438\u0441\u043e\u0432',
            },
        ),
    ]
