# flake8: noqa
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('resources', '0037_serviceresource_state_index'),
    ]

    operations = [
        migrations.CreateModel(
            name='ResourceClosure',
            fields=[
                (
                    'id',
                    models.AutoField(
                        verbose_name='ID',
                        serialize=False,
                        auto_created=True,
                        primary_key=True
                    )
                ),
                ('depth', models.IntegerField()),
                (
                    'child',
                    models.ForeignKey(
                        related_name='resourceclosure_parents',
                        to='resources.Resource'
                    )
                ),
                (
                    'parent',
                    models.ForeignKey(
                        related_name='resourceclosure_children',
                        to='resources.Resource'
                    )
                ),
            ],
            options={
                'db_table': 'resources_resourceclosure',
            },
        ),
        migrations.AlterUniqueTogether(
            name='resourceclosure',
            unique_together=set([('parent', 'child')]),
        ),
    ]
