# flake8: noqa
from django.db import migrations


def add_dispenser_project_type(apps, schema_editor):
    Service = apps.get_model('services', 'Service')
    ResourceType = apps.get_model('resources', 'ResourceType')

    dispenser = Service.objects.get(slug='dispenser')
    ResourceType.objects.get_or_create(
        supplier=dispenser,
        code='dispenser_project',
        name='Проект',
        import_plugin='dispenser'
    )


class Migration(migrations.Migration):

    dependencies = [
        ('services', '0048_delete_serviceresponsible'),
        ('resources', '0044_resource_type_code'),
    ]

    operations = [
        migrations.RunPython(add_dispenser_project_type, migrations.RunPython.noop),
    ]
