# flake8: noqa
# Generated by Django 1.9.13 on 2018-09-07 14:40


from urllib.parse import urljoin

from django.conf import settings
from django.db import migrations


def prefill_form_id(apps, schema_editor):
    ResourceType = apps.get_model('resources', 'ResourceType')

    resource_types = ResourceType.objects.filter(form_link__isnull=False)

    for resource_type in resource_types:
        if resource_type.form_link:
            resource_type.form_id = int(resource_type.form_link.split('/')[-2])
            resource_type.save()


def refill_form_links(apps, schema_editor):
    ResourceType = apps.get_model('resources', 'ResourceType')

    resource_types = ResourceType.objects.filter(form_id__isnull=False)

    for resource_type in resource_types:
        resource_type.form_link = urljoin(
            settings.CONSTRUCTOR_FORM_FRONTEND_URL,
            'survey/{}/'.format(resource_type.form_id)
        )
        resource_type.save()


class Migration(migrations.Migration):

    dependencies = [
        ('resources', '0047_resource_type_form_id'),
    ]

    operations = [
        migrations.RunPython(prefill_form_id, refill_form_links),
    ]
