# flake8: noqa
# Generated by Django 1.9.13 on 2018-11-14 11:03


from django.db import migrations


def initialize_roles_and_scopes(apps, schema_editor):
    ResourceType = apps.get_model('resources', 'ResourceType')
    RoleScope = apps.get_model('roles', 'RoleScope')
    Role = apps.get_model('roles', 'Role')
    dev_and_adm_scopes = RoleScope.objects.filter(slug__in=['development', 'administration'])
    responsible_roles = Role.objects.filter(code__in=['product_head', 'product_deputy_head', 'responsible'])

    # Уже есть consumer_roles => заполняем только supplier_
    for resource_type in ResourceType.objects.filter(consumer_roles__isnull=False):
        resource_type.supplier_roles.add(*responsible_roles)
        resource_type.supplier_scopes.add(*dev_and_adm_scopes)

    # Нет consumer_roles => заполняем все
    for resource_type in ResourceType.objects.filter(consumer_roles__isnull=True):
        resource_type.consumer_roles.add(*responsible_roles)
        resource_type.consumer_scopes.add(*dev_and_adm_scopes)
        resource_type.supplier_roles.add(*responsible_roles)
        resource_type.supplier_scopes.add(*dev_and_adm_scopes)


class Migration(migrations.Migration):

    dependencies = [
        ('resources', '0052_auto_20181114_1403'),
    ]

    operations = [
        migrations.RunPython(initialize_roles_and_scopes)
    ]
