# flake8: noqa
from django.db import migrations, models

from plan.resources.models import ServiceResource


states = '(%s)' % ','.join("'%s'" % state for state in ServiceResource.ALIVE_STATES)


class Migration(migrations.Migration):

    dependencies = [
        ('resources', '0066_remove_old_constraint'),
    ]

    operations = [
        migrations.RunSQL('''
            CREATE UNIQUE INDEX resources_serviceresource_resource_id_service_id
            ON resources_serviceresource (resource_id, service_id)
            WHERE state IN %s
        ''' % states, reverse_sql='''
            DROP INDEX IF EXISTS resources_serviceresource_resource_id_service_id
        ''')
    ]
