# flake8: noqa
from django.db import migrations, models
from django.utils import timezone


def set_approved_at(apps, schema):
    now = timezone.now()
    ServiceResource = apps.get_model('resources', 'ServiceResource')
    service_resources = ServiceResource.objects.filter(state__in=['approved', 'granting'])
    service_resources.update(approved_at=now)


class Migration(migrations.Migration):

    dependencies = [
        ('resources', '0072_service_resource_approved_at'),
    ]

    operations = [
        migrations.RunPython(
            code=set_approved_at,
            reverse_code=lambda *args, **kwargs: None
        ),
    ]
