# flake8: noqa
from __future__ import unicode_literals

from django.db import migrations

index_name = "typeid_answerid_unique"

forward_sql = """
    CREATE UNIQUE INDEX %s 
    ON resources_resource (type_id, answer_id) 
    WHERE obsolete_id IS NULL AND answer_id IS NOT NULL;
"""

backward_sql = "DROP INDEX %s;"


class Migration(migrations.Migration):

    dependencies = [
        ('resources', '0081_fake_py3_migration'),
    ]

    operations = [
        migrations.RunSQL(forward_sql % index_name, backward_sql % index_name),
    ]
