# flake8: noqa
from django.db import migrations


class Migration(migrations.Migration):
    """
    Создает индекс по ts_vector из значений 3 колонок, объединенных через пробел.

    Поскольку нативный SearchVector объединяет свои поля аргументы через пробел, для использования индекса нужно
    чтобы он был построен при помощи аналогичной конструкции.
    """

    atomic = False

    dependencies = [
        ('resources', '0086_serviceresourcecounter'),
    ]

    operations = [
        migrations.RunSQL(
            [
                """
                CREATE INDEX CONCURRENTLY resources_resource_search_simple_idx ON resources_resource
                USING GIN (to_tsvector('simple', COALESCE(id::varchar(32), '') || ' ' || COALESCE(name, '') || ' ' || COALESCE(external_id, '')));
                """
            ],
            reverse_sql=[
                """
                DROP INDEX CONCURRENTLY resources_resource_search_simple_idx;
                """
            ],
        ),
    ]
