from rest_framework import routers

from plan.resources.api.constructor import ConstructorFormView
from plan.resources.api.financial import FinancialResourceRequestView
from plan.resources.api.request import RequestResourceView
from plan.resources.api.resource_tag_categories import ResourceTagCategoryView
from plan.resources.api.resource_tags import ResourceTagView
from plan.resources.api.resource_type_categories import ResourceTypeCategoryView
from plan.resources.api.resource_types import ResourceTypesView
from plan.resources.api.resources import ResourcesView
from plan.resources.api.service_resources import ServiceResourcesView
from plan.resources.api.robots import RobotView


router = routers.DefaultRouter()

router.register(r'categories', ResourceTagCategoryView, basename='category')
router.register(r'request/form', ConstructorFormView, basename='resource-form')
router.register(r'request', RequestResourceView, basename='request')
router.register(r'resources', ResourcesView, basename='resources')
router.register(r'robots', RobotView, basename='robots')
router.register(r'financial_resources', FinancialResourceRequestView, basename='financial-resources')
router.register(r'serviceresources', ServiceResourcesView, basename='serviceresources')
router.register(r'tags', ResourceTagView, basename='tag')
router.register(r'typecategories', ResourceTypeCategoryView, basename='typecategory')
router.register(r'types', ResourceTypesView, basename='resourcetypes')
