from django.conf import settings

from plan.services.models import ServiceTag
from plan.resources.suppliers.base import SupplierPlugin


class BillingPoint(SupplierPlugin):

    def can_delete_resource(self, person, service_resource):
        result = super().can_delete_resource(person, service_resource)
        if result:
            result = service_resource.service.get_ancestors(include_self=False).filter(
                tags__slug=settings.OEBS_BILLING_AGGREGATION_TAG,
            ).exists()

        return result

    def edit(self, service_resource, request):
        pass

    def create(self, service_resource):
        service_resource.service.tags.add(
            ServiceTag.objects.get(slug=settings.OEBS_BILLING_AGGREGATION_TAG)
        )
        return None, None

    def delete(self, service_resource, request):
        service_resource.service.tags.remove(
            ServiceTag.objects.get(slug=settings.OEBS_BILLING_AGGREGATION_TAG)
        )
