from django.db.models import Q
from django.utils.translation import ugettext_lazy as _

from rest_framework.serializers import ValidationError

from plan.roles.models import Role


def scope_is_not_protected(value):
    if value.protected:
        raise ValidationError(_('В этом скоупе ролей нельзя создавать локальные роли.'))


class RoleNameIsUniqueWithinScope(object):
    def __call__(self, attrs, *args, **kwargs):
        service = attrs.get('service')
        scope = attrs.get('scope')
        name = attrs.get('name')
        name_en = attrs.get('name_en')

        existing_roles = Role.objects.filter(scope=scope).filter(Q(service=service) | Q(service=None))
        if existing_roles.filter(name=name):
            raise ValidationError(
                _('Роль с таким названием уже существует в этом скоупе ролей, выберите другое.')
            )
        elif existing_roles.filter(name_en=name_en):
            raise ValidationError(
                _('Роль с таким английским названием уже существует в этом скоупе ролей, выберите другое.')
            )
