from plan.api import exceptions


class RoleAlreadyRequested(exceptions.Conflict):
    default_code = 'role_already_requested'

    def __init__(self, person, role, service):
        super(RoleAlreadyRequested, self).__init__()
        self.message = {
            'ru': 'IDM говорит нам, что роль {} для {}@ в сервисе {} уже была запрошена'
                  .format(role.id, person.login, service.slug),
            'en': 'IDM tells us that role {} for {}@ in service {} has already been requested'
                  .format(role.id, person.login, service.slug)
        }


class DepartmentRoleAlreadyRequested(exceptions.Conflict):
    default_code = 'role_already_requested'

    def __init__(self, department, role, service):
        super(DepartmentRoleAlreadyRequested, self).__init__()
        self.message = {
            'ru': 'IDM говорит нам, что роль {} для департамента {} в сервисе {} уже была запрошена'
                  .format(role.id, department.code, service.slug),
            'en': 'IDM tells us that role {} for department {} in service {} has already been requested'
                  .format(role.id, department.code, service.slug)
        }
