from django import forms
from rest_framework import serializers

from plan.common.utils import rest_fw
from plan.roles import models


class RoleCreateSerializer(rest_fw.PlanSerializer):
    name = rest_fw.LocaleSerializer()
    scope = serializers.IntegerField(required=False)
    service = serializers.IntegerField(required=False)


class RoleCreateForm(forms.ModelForm):
    class Meta:
        model = models.Role
        fields = ('name', 'name_en', 'scope', 'service')

    def save(self, commit=True):
        obj = super(RoleCreateForm, self).save(commit=False)
        # set extra fields here
        obj.native_lang = 'ru'
        return super(RoleCreateForm, self).save(commit=commit)
