# flake8: noqa
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Role',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('native_lang', models.CharField(default=b'', max_length=2, blank=True)),
                ('name', models.CharField(max_length=255, db_index=True)),
                ('name_en', models.CharField(max_length=255, db_index=True)),
                ('position', models.IntegerField(default=220, db_index=True)),
                ('weight', models.PositiveSmallIntegerField(default=0, verbose_name='\u0412\u0430\u0436\u043d\u043e\u0441\u0442\u044c \u0440\u043e\u043b\u0438')),
                ('code', models.CharField(default='other', max_length=32, db_index=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('modified_at', models.DateTimeField(auto_now=True)),
                ('projected_role', models.ForeignKey(related_name='+', default=None, blank=True, to='roles.Role', null=True)),
            ],
            options={
                'ordering': ('position', 'name'),
            },
        ),
        migrations.CreateModel(
            name='RoleScope',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('native_lang', models.CharField(default=b'', max_length=2, blank=True)),
                ('slug', models.CharField(unique=True, max_length=255)),
                ('name', models.CharField(max_length=255)),
                ('name_en', models.CharField(max_length=255)),
            ],
        ),
        migrations.AddField(
            model_name='role',
            name='scope',
            field=models.ForeignKey(on_delete=django.db.models.deletion.SET_NULL, default=None, blank=True, to='roles.RoleScope', null=True),
        ),
    ]
