# flake8: noqa
from collections import defaultdict
from itertools import chain

from django.db import migrations


def rename_duplicate_roles(apps, schema_editor):
    Role = apps.get_model('roles', 'Role')

    data = {
        'name': defaultdict(list),
        'name_en': defaultdict(list)
    }

    for role in Role.objects.all():
        for attr, storage in data.items():
            storage[(role.scope, getattr(role, attr))].append(role.id)

    for attr, roles in data.items():
        duplicates = chain(*(values for values in roles.values() if len(values) > 1))
        for duplicate in duplicates:
            role = Role.objects.get(id=duplicate)
            if role.service is not None:
                setattr(role, attr, '{} ({})'.format(getattr(role, attr), role.service.slug))
                role.save()


class Migration(migrations.Migration):

    dependencies = [
        ('roles', '0003_protected_role_scopes'),
    ]

    operations = [
        migrations.RunPython(rename_duplicate_roles, migrations.RunPython.noop),
    ]
