from django.db import models
from django.conf import settings
from django.core.cache import cache


class RoleQueryset(models.QuerySet):
    def get_resource_management_roles_pks(self, resource_category, fresh=False):
        pks = None
        if not fresh:
            pks = cache.get(f'{resource_category}_management_roles_pks')
        if pks is None:
            pks = list(
                self.filter(code__in=settings.RESOURCE_MANAGEMENT_ROLES[resource_category])
                .globalwide()
                .values_list('pk', flat=True)
            )
            cache.set(
                f'{resource_category}_management_roles_pks',
                pks,
                timeout=settings.RESOURCE_MANAGEMENT_ROLES_CACHE_TIMEOUT
            )
        return pks

    def globalwide(self):
        return self.filter(service=None)

    def service_specific(self):
        return self.filter(service__isnull=False)
