import logging

from django.conf import settings

from plan.api.idm import actions
from plan.celery_app import app
from plan.idm.exceptions import IDMError
from plan.services.models import ServiceMember
from plan.services.tasks import notify_staff

log = logging.getLogger(__name__)


@app.task(bind=True)
def deprive_role(self, service_member_id, comment=''):
    member = ServiceMember.objects.get(id=service_member_id)

    try:
        actions.deprive_role(member, comment=comment,)
    except IDMError as exc:
        self.retry(exc=exc, args=(service_member_id, comment))

    notify_staff.apply_async(
        args=[member.service.id],
        countdown=settings.ABC_DEFAULT_COUNTDOWN
    )
