FRONTEND_DEEP_FILTERS = {
    'member',
    'responsible',
    'owner',
    'search',
    'department',
}

DEEP_FILTER_MODE_LABEL = 'deep'
SHALLOW_FILTER_MODE_LABEL = 'shallow'

MATCHED_LABEL = 'matched'


ROOT_KEY = 'root'


class FrontendTagsSerializerField(object):
    META_FIELDS = (
        'color',
        'description',
        'id',
        'name',
        'slug',
    )
    FIELDS_LIST_TO_SELECT = META_FIELDS + ('name_en', 'description_en', 'service__id')


class FrontendServiceSerializerFields(object):
    META_FIELDS = (
        'children_count',
        'created_at',
        'id',
        'is_exportable',
        'is_suspicious',
        'sandbox_move_date',
        'kpi',
        'modified_at',
        'name',
        'owner',
        'parent',
        'readonly_state',
        'slug',
        'state',
        'tags',
        'unique_immediate_members_count',
        'unique_immediate_robots_count',
        'unique_immediate_external_members_count',
        'has_forced_suspicious_reason',
        'has_external_members',
        'traffic_light',
        'level',
        MATCHED_LABEL,
    )
    _EXCLUDE = {MATCHED_LABEL, 'is_suspicious', 'kpi', 'type', 'traffic_light', 'tags', 'owner'}
    _INCLUDE = {
        'kpi_bugs_count',
        'kpi_release_count',
        'kpi_lsr_count',
        'name_en',
        'service_type',
        'service_type__id',
        'service_type__code',
        'service_type__name',
        'service_type__name_en',
        'owner__login',
        'owner__first_name',
        'owner__last_name',
        'owner__first_name_en',
        'owner__last_name_en',
        'parent_id',
        'membership_inheritance',
    }
    FIELD_LIST_TO_SELECT = (set(META_FIELDS) | _INCLUDE) - _EXCLUDE
