from copy import copy

from django.conf import settings

from plan.resources.models import ServiceResource
from plan.services.models import Service

FUNCTIONALITIES_CHECKER = {
    settings.RESOURCE_CONSUME_FUNCTION: lambda service, **kwargs: ServiceResource.objects.filter(
        service=service,
    ).active().exists(),
    settings.STAFF_EXPORT_FUNCTION: lambda service, **kwargs: service.is_exportable,
    settings.SERVICE_ROLES_FUNCTION: lambda service, **kwargs:  service.id in kwargs['services_with_utility_scope'],
    settings.FUNCTIONAL_ROLES_FUNCTION: lambda service, **kwargs: service.id in kwargs['services_with_functional_scope'],
    settings.OEBS_FUNCTION: lambda service, **kwargs: service.with_oebs_flags(),
    settings.WARDEN_FUNCTION: lambda service, **kwargs: service.id in kwargs['services_with_warden'],
    settings.RESOURCE_PROVIDE_FUNCTION: lambda service, **kwargs: service.id in kwargs['suppliers'],
    settings.QUOTAS_FUNCTION: lambda service, **kwargs: True,  # ждем DISPENSER-5501
    settings.HARDWARE_FUNCTION: lambda service, **kwargs: True,  # ждем DISPENSER-5501
    settings.PARENT_SELECT_FUNCTION: lambda service, **kwargs: False,
    settings.DUTY_FUNCTION: lambda service, **kwargs: service.id in kwargs['services_with_schedules'],
}


def get_service_functions(
    service: Service,
    functions_by_type: dict,
    active_functionalities: list[str],
    services_with_schedules: set[int],
    services_with_functional_scope: set[int],
    services_with_utility_scope: set[int],
    services_with_warden: set[int],
    suppliers: set[int],
) -> list:
    base_functions = copy(functions_by_type[service.service_type_id])
    for function_key, function_checker in FUNCTIONALITIES_CHECKER.items():
        if (
            function_key in active_functionalities and
            function_key not in base_functions and
            function_checker(
                service,
                services_with_schedules=services_with_schedules,
                services_with_functional_scope=services_with_functional_scope,
                services_with_utility_scope=services_with_utility_scope,
                services_with_warden=services_with_warden,
                suppliers=suppliers,
            )
        ):
            base_functions.append(function_key)

    return base_functions
