from django.core.management.base import BaseCommand
from django.conf import settings

from plan.services.models import Service


OCCUPANCY_CONTACT_TYPE = 'other'


class Command(BaseCommand):
    def handle_noargs(self, *args, **options):
        created_count = 0

        for s in Service.objects.filter(state__in=Service.states.ALIVE_STATES):

            if s.is_important:
                occupancy_contacts_query = s.contacts.filter(
                    contact_type=OCCUPANCY_CONTACT_TYPE,
                    title='Коэффициенты',
                )
                if not occupancy_contacts_query.count():
                    url = '{occupancy_url}/services/{service_id}/'.format(
                        occupancy_url=settings.OCCUPANCY_URL,
                        service_id=s.id,
                    )
                    s.contacts.create(
                        content=url,
                        contact_type=OCCUPANCY_CONTACT_TYPE,
                        title='Коэффициенты',
                    )
                    created_count += 1

        print("Created {} link(s)".format(created_count))
