# coding: utf-8
from __future__ import unicode_literals

from django.core.management.base import BaseCommand
from django.conf import settings

from plan.services.models import Service, ServiceMoveRequest
from plan.common.utils.oauth import get_abc_zombik
from plan.common.person import Person


OCCUPANCY_CONTACT_TYPE = 'other'


class Command(BaseCommand):

    def handle(self, *args, **options):
        zombik = Person(get_abc_zombik())
        sandbox = Service.objects.get(slug=settings.ABC_DEFAULT_SERVICE_PARENT_SLUG)

        self._approve_inside(zombik, sandbox)
        self._approve_outside(zombik, sandbox)

    def _approve_inside(self, zombik, sandbox):
        # Аппрувим переезды в песочницу
        # Нам не надо трогать реквесты в REQUESTED потому что они правиьно поменяют состояние при аппруве человеком
        requests = ServiceMoveRequest.objects.filter(
            destination=sandbox,
            state=ServiceMoveRequest.PARTIALLY_APPROVED,
            approver_outgoing__isnull=False,
        )
        for request in requests:
            request.approve(zombik)

    def _approve_outside(self, zombik, sandbox):
        services_in_sandbox = sandbox.get_descendants()
        # Нам не надо трогать реквесты в REQUESTED потому что они правиьно поменяют состояние при аппруве человеком
        requests = (
            ServiceMoveRequest.objects.filter(
                state=ServiceMoveRequest.PARTIALLY_APPROVED,
                approver_incoming__isnull=False,
                service__in=services_in_sandbox
            ).exclude(
                destination__in=services_in_sandbox
            )
        )
        for request in requests:
            request.approve(zombik)
