from django.core.management.base import BaseCommand, CommandError

from plan.services.models import Service


class Command(BaseCommand):
    help = 'Disable membership_inheritance recursively'

    def add_arguments(self, parser):
        parser.add_argument('--service_id', type=int)

    def handle(self, *args, **kwargs):
        service_id = kwargs['service_id']
        try:
            service = Service.objects.get(id=service_id)
        except Service.DoesNotExist:
            raise CommandError(f'Service with id {service_id} does not exist')

        self._disable_inheritance(service)

    def _disable_inheritance(self, root):
        root.membership_inheritance = False
        root.save(update_fields=('membership_inheritance',))
        descendants = root.get_descendants()
        descendants.update(membership_inheritance=False)

        self.stdout.write(self.style.SUCCESS(
            f'membership_inheritance set False for {1 + len(descendants)} services'
        ))
