# encoding: utf-8


from django.core.management.base import BaseCommand

from plan.roles.models import Role
from plan.services.models import Service, ServiceMember


class Command(BaseCommand):
    def handle(self, *args, **options):
        for service in Service.objects.filter(owner=None):
            print('Service %s' % service.slug)
            roles = ServiceMember.objects.filter(service=service, role__code=Role.EXCLUSIVE_OWNER)

            if roles.exists():
                service.owner = roles[0].staff
                service.save()

                print('set owner to %s' % service.owner.login)

            else:
                print('no head')
