# flake8: noqa
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('staff', '0001_initial'),
        ('roles', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Service',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('native_lang', models.CharField(default=b'', max_length=2, blank=True)),
                ('state', models.CharField(default='init', max_length=32, verbose_name='\u0421\u0442\u0430\u0442\u0443\u0441', db_index=True, choices=[('develop', '\u0420\u0430\u0437\u0432\u0438\u0432\u0430\u0435\u0442\u0441\u044f'), ('supported', '\u041f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f'), ('needinfo', '\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f'), ('closed', '\u0417\u0430\u043a\u0440\u044b\u0442'), (b'deleted', '\u0423\u0434\u0430\u043b\u0451\u043d')])),
                ('name', models.CharField(max_length=255, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435')),
                ('name_en', models.CharField(default='', max_length=255, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (en)', blank=True)),
                ('slug', models.SlugField(unique=True, verbose_name='\u041a\u043e\u0434')),
                ('description', models.TextField(default='', verbose_name='\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435', blank=True)),
                ('description_en', models.TextField(default='', verbose_name='\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435', blank=True)),
                ('formatted_description', models.TextField(default='', verbose_name='\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435', blank=True)),
                ('formatted_description_en', models.TextField(default='', verbose_name='\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435', blank=True)),
                ('url', models.CharField(default='', max_length=255, verbose_name='\u0410\u0434\u0440\u0435\u0441 \u0441\u0435\u0440\u0432\u0438\u0441\u0430', blank=True)),
                ('keywords', models.TextField(default='', verbose_name='\u041a\u043b\u044e\u0447\u0435\u0432\u044b\u0435 \u0441\u043b\u043e\u0432\u0430', blank=True)),
                ('position', models.IntegerField(default=0, editable=False, db_index=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('modified_at', models.DateTimeField(auto_now=True)),
                ('is_vteam', models.BooleanField(default=False, verbose_name='\u042d\u0442\u043e v-team')),
                ('is_external', models.BooleanField(default=False, verbose_name='\u0412\u043d\u0435\u0448\u043d\u0438\u0439 \u0441\u0435\u0440\u0432\u0438\u0441')),
                ('is_important', models.BooleanField(default=False, verbose_name='\u0412\u0430\u0436\u043d\u044b\u0439')),
                ('unique_members_count', models.PositiveSmallIntegerField(default=0, verbose_name='\u0427\u0438\u0441\u043b\u043e \u0443\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0445 \u0443\u0447\u0430\u0441\u0442\u043d\u0438\u043a\u043e\u0432 \u0441\u0435\u0440\u0432\u0438\u0441\u0430')),
                ('unique_immediate_members_count', models.PositiveSmallIntegerField(default=0, verbose_name='\u0427\u0438\u0441\u043b\u043e \u0443\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0435\u043f\u043e\u0441\u0440\u0435\u0434\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0443\u0447\u0430\u0441\u0442\u043d\u0438\u043a\u043e\u0432 \u0441\u0435\u0440\u0432\u0438\u0441\u0430')),
                ('weight', models.PositiveSmallIntegerField(default=0, verbose_name='\u0412\u0430\u0436\u043d\u043e\u0441\u0442\u044c (\u0432\u0435\u0441) \u0441\u0435\u0440\u0432\u0438\u0441\u0430')),
                ('path', models.CharField(default='', max_length=1000, verbose_name='\u041f\u0443\u0442\u044c \u043f\u043e slug \u043f\u0440\u043e\u0435\u043a\u0442\u043e\u0432', blank=True)),
                ('is_updated_wiki_fields', models.BooleanField(default=False)),
                ('lft', models.PositiveIntegerField(editable=False, db_index=True)),
                ('rght', models.PositiveIntegerField(editable=False, db_index=True)),
                ('tree_id', models.PositiveIntegerField(editable=False, db_index=True)),
                ('level', models.PositiveIntegerField(editable=False, db_index=True)),
                ('base_of', models.ManyToManyField(related_name='based_on', verbose_name='\u041e\u0441\u043d\u043e\u0432\u0430 \u0434\u043b\u044f', to='services.Service', blank=True)),
                ('active_projects_count', models.PositiveSmallIntegerField(default=0)),
                ('total_projects_count', models.PositiveSmallIntegerField(default=0)),
                ('direction_id', models.IntegerField(default=0)),
            ],
            options={
                'permissions': (('change_importance', '\u0418\u0437\u043c\u0435\u043d\u044f\u0442\u044c \u0432\u0430\u0436\u043d\u043e\u0441\u0442\u044c'), ('moderate', '\u0423\u043f\u0440\u0430\u0432\u043b\u044f\u0442\u044c \u0441\u0435\u0440\u0432\u0438\u0441\u0430\u043c\u0438')),
            },
        ),
        migrations.CreateModel(
            name='ServiceChownRequest',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('is_deleted', models.BooleanField(default=False)),
                ('notified', models.DateTimeField(null=True)),
                ('new_owner', models.ForeignKey(related_name='+', to='staff.Staff')),
                ('requester', models.ForeignKey(related_name='+', to='staff.Staff')),
                ('service', models.ForeignKey(related_name='chown_requests', to='services.Service')),
                ('orange_id', models.CharField(null=True, max_length=24)),
            ],
        ),
        migrations.CreateModel(
            name='ServiceContact',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('content', models.CharField(max_length=255, verbose_name='\u041a\u043e\u043d\u0442\u0435\u043d\u0442', db_index=True)),
                ('contact_type', models.CharField(db_index=True, max_length=32, blank=True)),
                ('title', models.CharField(default='', max_length=255, verbose_name='\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a', blank=True)),
                ('comment', models.CharField(default='', max_length=255, verbose_name='\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439', blank=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('modified_at', models.DateTimeField(auto_now=True)),
                ('deleted', models.BooleanField(default=False)),
                ('position', models.PositiveIntegerField(default=0, editable=False)),
                ('service', models.ForeignKey(related_name='contacts', to='services.Service')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ServiceMember',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('state', models.CharField(default='init', max_length=32, verbose_name='C\u0442\u0430\u0442\u0443\u0441', db_index=True, choices=[('init', '\u0421\u043e\u0437\u0434\u0430\u043d'), ('waiting_approval', '\u041e\u0436\u0438\u0434\u0430\u0435\u0442 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f'), ('approved', '\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0451\u043d'), ('deleted', '\u0423\u0434\u0430\u043b\u0451\u043d')])),
                ('custom_role', models.CharField(default='', max_length=255, verbose_name='\u0421\u0432\u043e\u0451 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0440\u043e\u043b\u0438', blank=True)),
                ('description', models.CharField(default='', max_length=255, verbose_name='\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435', blank=True)),
                ('position', models.IntegerField(default=0, editable=False, db_index=True)),
                ('is_temp', models.BooleanField(default=False, verbose_name='\u0412\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u0438\u0441\u043f\u043e\u043b\u043d\u044f\u044e\u0449\u0438\u0439 \u043e\u0431\u044f\u0437\u0430\u043d\u043d\u043e\u0441\u0442\u0438')),
                ('occupancy', models.PositiveSmallIntegerField(default=0, blank=True, verbose_name='\u0423\u0447\u0430\u0441\u0442\u0438\u0435', choices=[(1, '\u043e\u0434\u043d\u0438\u043c \u0433\u043b\u0430\u0437\u043e\u043c'), (8, '\u043f\u043e\u043b\u043d\u0430\u044f'), (4, '\u0447\u0430\u0441\u0442\u0438\u0447\u043d\u0430\u044f')])),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('modified_at', models.DateTimeField(auto_now=True)),
                ('is_senior', models.BooleanField(default=False, verbose_name='\u0413\u043b\u0430\u0432\u043d\u044b\u0439')),
                ('weight', models.PositiveSmallIntegerField(default=0, verbose_name='\u0412\u0435\u0441 \u0432 \u0441\u0435\u0440\u0432\u0438\u0441\u0435')),
                ('part_rate', models.DecimalField(null=True, max_digits=5, decimal_places=4, blank=True)),
                ('approve_orange_id', models.CharField(null=True, max_length=24)),
            ],
        ),
        migrations.CreateModel(
            name='ServiceMemberDepartment',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('modified_at', models.DateTimeField(auto_now=True)),
                ('state', models.CharField(default='new', max_length=32, db_index=True, choices=[('new', '\u041d\u043e\u0432\u044b\u0439'), ('waiting_deletion', '\u041e\u0436\u0438\u0434\u0430\u0435\u0442 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f'), ('deleted', '\u0423\u0434\u0430\u043b\u0451\u043d')])),
                ('department', models.ForeignKey(to='staff.Department')),
                ('role', models.ForeignKey(default=None, blank=True, to='roles.Role', null=True, verbose_name='\u0420\u043e\u043b\u044c')),
                ('service', models.ForeignKey(related_name='department_memberships', to='services.Service')),
                ('approve_orange_id', models.CharField(null=True, max_length=24)),
                ('remove_orange_id', models.CharField(null=True, max_length=24)),
            ],
        ),
        migrations.CreateModel(
            name='ServiceMoveRequest',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('is_deleted', models.BooleanField(default=False)),
                ('outcoming_notified', models.DateTimeField(null=True)),
                ('incoming_notified', models.DateTimeField(null=True)),
                ('approver_incoming', models.ForeignKey(related_name='+', to='staff.Staff', null=True)),
                ('approver_outcoming', models.ForeignKey(related_name='+', to='staff.Staff', null=True)),
                ('destination', models.ForeignKey(related_name='incoming_move_requests', to='services.Service')),
                ('requester', models.ForeignKey(related_name='service_move_requests', to='staff.Staff')),
                ('service', models.ForeignKey(related_name='move_requests', to='services.Service')),
                ('outcoming_orange_id', models.CharField(null=True, max_length=24)),
                ('incoming_orange_id', models.CharField(null=True, max_length=24)),
            ],
        ),
        migrations.CreateModel(
            name='ServiceResponsible',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('is_editable', models.BooleanField(default=True, verbose_name='\u041c\u043e\u0436\u043d\u043e \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('service', models.ForeignKey(related_name='responsible', to='services.Service')),
                ('staff', models.ForeignKey(verbose_name='\u0421\u043e\u0442\u0440\u0443\u0434\u043d\u0438\u043a', to='staff.Staff')),
            ],
        ),
        migrations.AddField(
            model_name='servicemember',
            name='from_department',
            field=models.ForeignKey(related_name='members', to='services.ServiceMemberDepartment', null=True),
        ),
        migrations.AddField(
            model_name='servicemember',
            name='role',
            field=models.ForeignKey(verbose_name='\u0420\u043e\u043b\u044c', to='roles.Role'),
        ),
        migrations.AddField(
            model_name='servicemember',
            name='service',
            field=models.ForeignKey(related_name='members', verbose_name='\u0421\u0435\u0440\u0432\u0438\u0441', to='services.Service'),
        ),
        migrations.AddField(
            model_name='servicemember',
            name='staff',
            field=models.ForeignKey(related_name='servicemembers', verbose_name='\u0421\u043e\u0442\u0440\u0443\u0434\u043d\u0438\u043a', to='staff.Staff'),
        ),
        migrations.AddField(
            model_name='service',
            name='member_departments',
            field=models.ManyToManyField(to='staff.Department', verbose_name='\u0421\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0435 \u043f\u043e\u0434\u0440\u0430\u0437\u0434\u0435\u043b\u0435\u043d\u0438\u044f', through='services.ServiceMemberDepartment'),
        ),
        migrations.AddField(
            model_name='service',
            name='owner',
            field=models.ForeignKey(related_name='responsible_for_services', verbose_name='\u0412\u043b\u0430\u0434\u0435\u043b\u0435\u0446', to='staff.Staff', null=True),
        ),
        migrations.AddField(
            model_name='service',
            name='parent',
            field=models.ForeignKey(related_name='children', blank=True, to='services.Service', null=True),
        ),
        migrations.AddField(
            model_name='service',
            name='team',
            field=models.ManyToManyField(related_name='services', through='services.ServiceMember', to='staff.Staff'),
        ),
        migrations.AlterUniqueTogether(
            name='serviceresponsible',
            unique_together=set([('service', 'staff')]),
        ),
    ]
