# flake8: noqa
from django.db import migrations


def clean_project_contacts(apps, schema_editor):
    # Мы выпилили проекты из планера, но в данных остались контанты с ссылками на проекты.
    # Их надо выпилить.
    ServiceContact = apps.get_model('services', 'ServiceContact')
    ServiceContact.objects.filter(contact_type='url_projects').delete()


class Migration(migrations.Migration):

    dependencies = [
        ('services', '0001_initial'),
    ]

    operations = [
        migrations.RunPython(clean_project_contacts, reverse_code=migrations.RunPython.noop),
    ]
