# flake8: noqa
from django.db import transaction, migrations


@transaction.atomic()
def add_vteam_tag(apps, schema_editor):
    ServiceTag = apps.get_model('services', 'ServiceTag')
    Service = apps.get_model('services', 'Service')

    vteam_tag = ServiceTag.objects.create(name='v-team', name_en='v-team', color='#649ede')

    services = Service.objects.filter(is_vteam=True)
    for service in services:
        service.tags.add(vteam_tag)
        service.save()


@transaction.atomic()
def remove_vteam_tag(apps, schema_editor):
    ServiceTag = apps.get_model('services', 'ServiceTag')
    ServiceTag.objects.filter(name='v-team', name_en='v-team').delete()


class Migration(migrations.Migration):

    dependencies = [
        ('services', '0011_readonly_state'),
    ]

    operations = [
        migrations.AlterUniqueTogether(
            name='servicetag',
            unique_together=set([('name', 'name_en', 'color')]),
        ),
        migrations.RunPython(add_vteam_tag, remove_vteam_tag)
    ]
