# flake8: noqa
from django.db import migrations, models


def fill_contacttypes(apps, schema_editor):
    ContactType = apps.get_model("contacts", "ContactType")
    ServiceContact = apps.get_model("services", "ServiceContact")

    for contact in ServiceContact.objects.all():
        try:
            contact_type = ContactType.objects.get(code=contact.contact_type)
            contact.type = contact_type
            contact.save()
        except ContactType.DoesNotExist:
            pass


class Migration(migrations.Migration):

    dependencies = [
        ('contacts', '0002_auto_20180118_1303'),
        ('services', '0013_auto_20180118_1344'),
    ]

    operations = [
        migrations.RunPython(fill_contacttypes),
    ]
