# flake8: noqa
from django.db import migrations, models


def update_descriptions(apps, schema_editor):
    ServiceTag = apps.get_model('services', 'ServiceTag')
    ServiceTag.objects.filter(description=None).update(description='')
    ServiceTag.objects.filter(description_en=None).update(description_en='')
    ServiceTag.objects.filter(formatted_description=None).update(formatted_description='')
    ServiceTag.objects.filter(formatted_description_en=None).update(formatted_description_en='')


class Migration(migrations.Migration):

    dependencies = [
        ('services', '0020_auto_20180312_0854'),
    ]

    operations = [
        migrations.RunPython(update_descriptions, reverse_code=migrations.RunPython.noop),
    ]
