# flake8: noqa
from django.db import migrations, models


def flag_existing_as_exportable(apps, schema_editor):
    Service = apps.get_model('services', 'Service')
    Service.objects.update(is_exportable=True)


class Migration(migrations.Migration):

    dependencies = [
        ('services', '0021_auto_20180312_0855'),
    ]

    operations = [
        migrations.AddField(
            model_name='service',
            name='is_exportable',
            field=models.BooleanField(
                default=False,
                verbose_name='\u0424\u043b\u0430\u0433, \u0447\u0442\u043e \u044d\u0442\u043e\u0442 \u0441\u0435\u0432\u0440\u0438\u0441 \u0435\u0449\u0435 \u043d\u0435 \u043f\u0435\u0440\u0435\u043d\u043e\u0441\u0438\u043b\u0441\u044f \u0438\u0437 \u0414\u0440\u0443\u0433\u0438\u0445 \u0421\u0435\u0440\u0432\u0438\u0441\u043e\u0432 \u0438 \u044d\u0442\u043e \u043c\u043e\u0436\u043d\u043e \u0441\u0434\u0435\u043b\u0430\u0442\u044c'
            ),
        ),
        migrations.RunPython(flag_existing_as_exportable, reverse_code=migrations.RunPython.noop),
    ]
