# flake8: noqa
from django.db import migrations, models


def fill_slug(apps, schema_editor):
    ServiceTag = apps.get_model('services', 'ServiceTag')
    for t in ServiceTag.objects.all():
        t.slug = t.name_en.lower()
        t.save()


class Migration(migrations.Migration):

    dependencies = [
        ('services', '0025_auto_20180326_1548'),
    ]

    operations = [
        migrations.AddField(
            model_name='servicetag',
            name='slug',
            field=models.SlugField(default='', verbose_name='\u041a\u043e\u0434'),
            preserve_default=False,
        ),
        migrations.RunPython(fill_slug, reverse_code=migrations.RunPython.noop),
        migrations.AlterField(
            model_name='servicetag',
            name='slug',
            field=models.SlugField(unique=True, verbose_name='\u041a\u043e\u0434'),
        ),
    ]
