# flake8: noqa
from django.db import migrations


def purge_deleted_memberships(apps, schema_editor):
    ServiceMember = apps.get_model('services', 'ServiceMember')
    ServiceMember.objects.filter(state='deleted').delete()

    ServiceMemberDepartment = apps.get_model('services', 'ServiceMemberDepartment')
    ServiceMemberDepartment.objects.filter(state='deleted').delete()


class Migration(migrations.Migration):

    dependencies = [
        ('services', '0032_remove_servicemember_is_senior'),
    ]

    operations = [
        migrations.RunPython(purge_deleted_memberships, reverse_code=migrations.RunPython.noop),
    ]
