# flake8: noqa
from django.db import migrations, models


def delete_contacts(apps, schema_editor):
    ServiceContact = apps.get_model('services', 'ServiceContact')
    ServiceContact.objects.filter(deleted=True).delete()


class Migration(migrations.Migration):

    dependencies = [
        ('services', '0037_default_service_state'),
    ]

    operations = [
        migrations.RunPython(delete_contacts, reverse_code=migrations.RunPython.noop)
    ]
