# flake8: noqa
from django.db import migrations


def forwards(apps, schema_editor):
    if schema_editor.connection.vendor != 'postgresql':
        return

    operations = [
        'alter table services_service alter column slug type citext;',
        'create index service_slug_case on services_service (lower(slug) text_pattern_ops);',
        'alter table services_service add constraint service_slug_length check (char_length(slug) <= 50);',
    ]
    for op in operations:
        schema_editor.execute(op)


def backwards(apps, schema_editor):
    if schema_editor.connection.vendor != 'postgresql':
        return

    operations = [
        'alter table services_service drop constraint service_slug_length;',
        'drop index service_slug_case;',
        'alter table services_service alter column slug type varchar(50);',
    ]
    for op in operations:
        schema_editor.execute(op)


class Migration(migrations.Migration):

    dependencies = [
        ('services', '0046_serviceresponsible_migrated'),
    ]

    operations = [
        migrations.RunPython(forwards, backwards),
    ]
