# flake8: noqa
# Generated by Django 1.9.13 on 2018-09-14 11:38


from collections import defaultdict

from django.db import migrations


def delete_duplicate_members(apps, schema_editor):
    ServiceMember = apps.get_model("services", "ServiceMember")

    members = defaultdict(list)
    for service_member in ServiceMember.objects.values('id', 'service', 'staff', 'role', 'from_department', 'resource'):
        key = (
            service_member['service'],
            service_member['staff'],
            service_member['role'],
            service_member['from_department'],
            service_member['resource']
        )
        members[key].append(service_member['id'])

    duplicates = {key: value for key, value in members.items() if len(value) > 1}
    for duplicate_memberships in duplicates.values():
        ServiceMember.objects.filter(id__in=duplicate_memberships).last().delete()


def delete_duplicate_department_members(apps, schema_editor):
    ServiceMemberDepartment = apps.get_model("services", "ServiceMemberDepartment")

    department_members = defaultdict(list)
    for department_member in ServiceMemberDepartment.objects.values('id', 'service', 'department', 'role', 'resource'):
        key = (
            department_member['service'],
            department_member['department'],
            department_member['role'],
            department_member['resource']
        )
        department_members[key].append(department_member['id'])

    duplicates = {key: value for key, value in department_members.items() if len(value) > 1}
    for duplicate_memberships in duplicates.values():
        ServiceMemberDepartment.objects.filter(id__in=duplicate_memberships).last().delete()


class Migration(migrations.Migration):

    dependencies = [
        ('services', '0050_alter_create_request_states'),
    ]

    operations = [
        migrations.RunPython(delete_duplicate_members, migrations.RunPython.noop),
        migrations.RunPython(delete_duplicate_department_members, migrations.RunPython.noop)
    ]
