# flake8: noqa
# Generated by Django 1.9.13 on 2018-11-22 00:22


from django.db import migrations, models


def fill_convert_department(apps, schema_editor):
    Service = apps.get_model('services', 'Service')
    for serv in Service.objects.filter(department__isnull=False):
        serv.departments.add(serv.department)


class Migration(migrations.Migration):

    dependencies = [
        ('staff', '0001_initial'),
        ('services', '0056_django_1_10'),
    ]

    operations = [
        migrations.AlterModelManagers(
             name='service',
             managers=[],
        ),
        migrations.AddField(
            model_name='service',
            name='departments',
            field=models.ManyToManyField(blank=True, default=None, null=True, related_name='departments', to='staff.Department', verbose_name='\u041f\u043e\u0434\u0440\u0430\u0437\u0434\u0435\u043b\u0435\u043d\u0438\u044f'),
        ),
        migrations.RunPython(fill_convert_department, reverse_code=migrations.RunPython.noop),
    ]
