# flake8: noqa
# Generated by Django 1.10.8 on 2018-11-29 12:42


from django.db import migrations, models
import django.db.models.deletion


def create_default_service_type(apps, schema_editor):
    ServiceType = apps.get_model('services', 'ServiceType')
    default_type = ServiceType.objects.create(code='service', name='Сервис', name_en='Service')

    Service = apps.get_model('services', 'Service')
    Service.objects.update(service_type=default_type)


class Migration(migrations.Migration):

    dependencies = [
        ('services', '0058_remove_service_department'),
    ]

    operations = [
        migrations.CreateModel(
            name='ServiceType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(db_index=True, max_length=64, unique=True)),
                ('name', models.CharField(max_length=64)),
                ('name_en', models.CharField(max_length=64)),
            ],
        ),
        migrations.AddField(
            model_name='service',
            name='service_type',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='services.ServiceType'),
        ),
        migrations.RunPython(create_default_service_type),
        migrations.AlterField(
            model_name='service',
            name='service_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='services.ServiceType'),
        ),
    ]
