# flake8: noqa
# Generated by Django 1.10.8 on 2019-09-16 16:32


from django.db import migrations, models
from django.db.models.expressions import F


def fill_found_in_staff_at(apps, schema):
    servicemember = apps.get_model('services', 'ServiceMember')
    max_id = servicemember.objects.latest('id').id
    id_step = 1000
    for i in range(0, max_id + 1, id_step):
        servicemember.objects.filter(id__gte=i, id__lt=i + id_step).update(found_in_staff_at=F('created_at'))


class Migration(migrations.Migration):

    dependencies = [
        ('services', '0082_base_service_susp_reason'),
    ]

    operations = [
        migrations.AddField(
            model_name='servicemember',
            name='found_in_staff_at',
            field=models.DateTimeField(db_index=True, null=True),
        ),
        migrations.RunPython(code=fill_found_in_staff_at, reverse_code=migrations.RunPython.noop)
    ]
