# flake8: noqa
# Generated by Django 1.10.8 on 2019-11-05 12:40


from django.utils import timezone
from django.db import migrations, models

def fill_readonly_start_time(apps, schema):
    service = apps.get_model('services', 'Service')
    max_id = service.objects.latest('id').id
    id_step = 1000
    for i in range(0, max_id + 1, id_step):
        service.objects.filter(
            id__gte=i,
            id__lt=i + id_step,
            readonly_state__isnull=False
        ).update(readonly_start_time=timezone.now())


class Migration(migrations.Migration):

    dependencies = [
        ('services', '0086_auto_20191105_1722'),
    ]

    operations = [
        migrations.AddField(
            model_name='service',
            name='readonly_start_time',
            field=models.DateTimeField(blank=True, default=None, null=True),
        ),
        migrations.RunPython(code=fill_readonly_start_time, reverse_code=migrations.RunPython.noop)
    ]
