from django.db import migrations


def forward_migration(apps, schema_editor):
    Shift = apps.get_model('duty', 'Shift')
    ServiceMember = apps.get_model('services', 'ServiceMember')
    started_shifts = Shift.objects.filter(
        staff__isnull=False,
        state='started',
    ).select_related('schedule')
    for shift in started_shifts:
        member = ServiceMember.objects.get(
            resource=None,
            from_department=None,
            service_id=shift.schedule.service_id,
            staff_id=shift.staff_id,
            role_id=shift.role_id,
        )
        member.autorequested = True
        member.save(update_fields=['autorequested'])


def backward_migration_stub(apps, schema_editor):
    pass


class Migration(migrations.Migration):
    atomic = False

    dependencies = [
        ('services', '0110_service_member_add_autorequested'),
    ]

    operations = [
        migrations.RunPython(forward_migration, reverse_code=backward_migration_stub, atomic=False),
    ]
