from django.db import migrations


def forward_migration(apps, schema_editor):
    Permission = apps.get_model('auth', 'Permission')
    ContentType = apps.get_model('contenttypes', 'ContentType')
    ServiceTag = apps.get_model('services', 'ServiceTag')
    for service_tag in ServiceTag.objects.all():
        Permission.objects.get_or_create(
            codename=f'change_service_tag_{service_tag.slug}',
            content_type=ContentType.objects.get(app_label='services', model='servicetag')
        )


def backward_migration_stub(apps, schema_editor):
    pass


class Migration(migrations.Migration):
    atomic = False

    dependencies = [
        ('services', '0116_servicetag_add_protected'),
    ]

    operations = [
        migrations.RunPython(forward_migration, reverse_code=backward_migration_stub, atomic=False),
    ]
